/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.net.Client;
import processing.net.Server;
import processing.serial.Serial;

public class _WEBB_WebServer_RobotComputer
extends PApplet {
    int serialPortIndex = -1;
    String[] commOptions;
    Serial serialPort;
    PFont font;
    Server wServer;
    int port = 12345;
    int cycleCount = 0;
    PImage bg;
    Button comm1;
    Button comm2;
    Button comm3;
    Button comm4;
    Button up;
    Button right;
    Button left;
    Button down;
    Button webServer;

    public void setup() {
        this.frameRate(5.0f);
        this.bg = this.loadImage("WEBB-background.png");
        this.size(700, 400);
        this.font = this.loadFont("ArialMT-72.vlw");
        this.commOptions = Serial.list();
        this.defineButtons();
        this.background(this.bg);
    }

    public void draw() {
        if (this.cycleCount == 0) {
            this.drawCommBox();
            this.drawTestBox();
            this.drawWebServerBox();
        }
        this.pollWebServer();
    }

    public void drawCommBox() {
        this.fill(0.0f, 0.0f, 0.0f);
        this.textFont(this.font, 15.0f);
        int n = 0;
        while (n < this.commOptions.length) {
            this.text(this.commOptions[n], 100.0f, 102 + n * 70);
            ++n;
        }
        if (this.serialPortIndex != -1) {
            this.fill(0.0f, 147.0f, 221.0f);
            this.ellipse(180.0f, 96 + 70 * this.serialPortIndex, 30.0f, 30.0f);
        }
    }

    public void drawTestBox() {
    }

    public void drawWebServerBox() {
        this.fill(0.0f, 0.0f, 0.0f);
        this.textFont(this.font, 30.0f);
        if (this.wServer == null) {
            this.text("Start", 553.0f, 210.0f);
        } else {
            String string = "Running.";
            if (this.cycleCount / 1 > 0) {
                string = String.valueOf(string) + ".";
            }
            if (this.cycleCount / 1 > 1) {
                string = String.valueOf(string) + ".";
            }
            if (this.cycleCount / 1 > 2) {
                string = String.valueOf(string) + ".";
            }
            if (this.cycleCount / 1 > 3) {
                this.cycleCount = 0;
            }
            this.text(string, 520.0f, 210.0f);
        }
        ++this.cycleCount;
    }

    public void mousePressed() {
        if (this.comm1.pressed()) {
            this.updateSerialPort(0);
        } else if (this.comm2.pressed()) {
            this.updateSerialPort(1);
        } else if (this.comm3.pressed()) {
            this.updateSerialPort(2);
        } else if (this.comm4.pressed()) {
            this.updateSerialPort(3);
        } else if (this.up.pressed()) {
            this.sendRobotCommand("F", 5);
        } else if (this.left.pressed()) {
            this.sendRobotCommand("L", 5);
        } else if (this.right.pressed()) {
            this.sendRobotCommand("R", 5);
        } else if (this.down.pressed()) {
            this.sendRobotCommand("B", 5);
        } else if (this.webServer.pressed()) {
            this.startWebServer();
        }
        this.cycleCount = 0;
        this.background(this.bg);
        this.draw();
    }

    public void pollWebServer() {
        Client client;
        if (this.wServer != null && (client = this.wServer.available()) != null) {
            String string = client.readString();
            String string2 = client.ip();
            String string3 = this.parseRequest(string.toUpperCase());
            if (string3.indexOf("REQUEST?") != -1) {
                String string4 = this.interpretRequest(string3);
                client.write("HTTP/1.1 200 OK\nConnection: close\nContent-Type: text/html\n\n" + string4);
                this.wServer.disconnect(client);
            } else if (string3.indexOf("CONTROLPAGE") != -1) {
                String[] stringArray = this.loadStrings("WEBB-ControlPage.html");
                String string5 = "";
                int n = 0;
                while (n < stringArray.length) {
                    string5 = String.valueOf(string5) + stringArray[n];
                    ++n;
                }
                client.write("HTTP/1.1 200 OK\nConnection: close\nContent-Type: text/html\n\n" + string5);
                this.wServer.disconnect(client);
            } else if (string3.indexOf("/TEST/") != -1) {
                _WEBB_WebServer_RobotComputer.println((String)string);
                _WEBB_WebServer_RobotComputer.println((String)string2);
                client.write("HTTP/1.1 200 OK\nConnection: close\nContent-Type: text/html\n\n");
                this.wServer.disconnect(client);
            } else {
                client.write("HTTP/1.1 404 FILE NOT FOUND\nConnection: close\n");
                this.wServer.disconnect(client);
            }
        }
    }

    public void defineButtons() {
        this.comm1 = new Button(30, 65, 60, 60);
        this.comm2 = new Button(30, 135, 60, 60);
        this.comm3 = new Button(30, 205, 60, 60);
        this.comm4 = new Button(30, 275, 60, 60);
        this.up = new Button(320, 110, 60, 60);
        this.left = new Button(260, 170, 60, 60);
        this.right = new Button(380, 170, 60, 60);
        this.down = new Button(320, 230, 60, 60);
        this.webServer = new Button(493, 170, 180, 60);
    }

    public void startWebServer() {
        if (this.wServer == null) {
            this.wServer = new Server((PApplet)this, this.port);
        }
    }

    public String parseRequest(String string) {
        string = string.substring(string.indexOf("GET ") + "GET ".length());
        string = string.substring(0, string.indexOf(" "));
        return string;
    }

    public void updateSerialPort(int n) {
        if (this.commOptions.length > n) {
            this.serialPortIndex = n;
        }
        if (this.serialPortIndex != -1) {
            if (this.serialPort != null) {
                this.serialPort.stop();
            }
            this.serialPort = new Serial((PApplet)this, Serial.list()[this.serialPortIndex], 9600);
        }
    }

    public String interpretRequest(String string) {
        String string2 = "OK";
        String string3 = string.indexOf("COMMAND=") != -1 ? string.substring(string.indexOf("COMMAND=") + "COMMAND=".length()) : "Z";
        if (string3.indexOf("&") != -1) {
            string3 = string3.substring(0, string3.indexOf("&"));
        }
        String string4 = string.indexOf("PARAM1=") != -1 ? string.substring(string.indexOf("PARAM1=") + "PARAM1=".length()) : "0";
        if (string4.indexOf("& ") != -1) {
            string4 = string4.substring(0, string4.indexOf("&"));
        }
        int n = Integer.parseInt(string4);
        this.sendRobotCommand(string3, n);
        string2 = "command: " + string3 + " param1: " + n;
        return string2;
    }

    public void sendRobotCommand(String string, int n) {
        _WEBB_WebServer_RobotComputer.println((String)("command: " + string + " time: " + n));
        String string2 = "AAA";
        if (this.serialPort != null) {
            this.serialPort.write(String.valueOf(string2) + string);
            this.serialPort.write((int)PApplet.parseByte((int)n));
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"_WEBB_WebServer_RobotComputer"});
    }

    class Button {
        int x;
        int y;
        int width;
        int height;

        Button(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.width = n3;
            this.height = n4;
        }

        public boolean pressed() {
            return this.overRect();
        }

        public boolean overRect() {
            return _WEBB_WebServer_RobotComputer.this.mouseX >= this.x && _WEBB_WebServer_RobotComputer.this.mouseX <= this.x + this.width && _WEBB_WebServer_RobotComputer.this.mouseY >= this.y && _WEBB_WebServer_RobotComputer.this.mouseY <= this.y + this.height;
        }
    }
}

