/*
    RetroWatch Arduino is a part of open source smart watch project.
    Copyright (C) 2014  Suh Young Bae

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see [http://www.gnu.org/licenses/].
*/
/*
Retro Watch Arduino v1.0

  Get the latest version, android host app, source code and guide doc at 
  ------> https://github.com/godstale/retrowatch
  ------> or http://www.hardcopyworld.com

Written by Suh Young Bae (godstale@hotmail.com)
All text above must be included in any redistribution
*/


////////////////////////////////////////////////////
// 16x24 Logo
////////////////////////////////////////////////////
const unsigned char PROGMEM IMG_logo_24x24[] = {
0x07,0xff,0xe0,
0x07,0xff,0xe0,
0x07,0xff,0xe0,
0x08,0x10,0x10,
0x10,0x10,0x08,
0x10,0x00,0x08,
0x10,0x00,0x08,
0x10,0x00,0x08,
0x10,0x00,0x08,
0x10,0x02,0x08,
0x10,0x04,0x08,
0x10,0x08,0x0c,
0x1c,0x10,0x3c,
0x10,0x08,0x0c,
0x10,0x08,0x08,
0x10,0x04,0x08,
0x10,0x04,0x08,
0x10,0x02,0x08,
0x10,0x02,0x08,
0x10,0x10,0x08,
0x08,0x10,0x10,
0x07,0xff,0xe0,
0x07,0xff,0xe0,
0x07,0xff,0xe0
}; 

////////////////////////////////////////////////////
// 8x8 Indicator
////////////////////////////////////////////////////
const unsigned char PROGMEM IMG_indicator_emg[] = {
0x00,
0x18,
0x18,
0x18,
0x00,
0x18,
0x00,
0x00
}; 

const unsigned char PROGMEM IMG_indicator_msg[] = {
0x00,
0x3c,
0x42,
0x42,
0x34,
0x08,
0x00,
0x00
}; 

////////////////////////////////////////////////////
// 16x16 icon bitmap matrix
////////////////////////////////////////////////////

#define GET_ICON(A) ICON_BITMAP_##A

//----- Change below count if you added new icon
#define ICON_ARRAY_SIZE 65

const unsigned char PROGMEM ICON_BITMAP_1[] = {
0x00,0x00,
0x00,0x00,
0x04,0x40,
0x07,0xc0,
0x0f,0xe0,
0x0b,0xa0,
0x1f,0xf0,
0x00,0x00,
0x5f,0xf4,
0x5f,0xf4,
0x5f,0xf4,
0x5f,0xf4,
0x1f,0xf0,
0x0c,0x60,
0x0c,0x60,
0x00,0x00
};
const unsigned char PROGMEM ICON_BITMAP_2[] = {
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x06,0xc0,
0x03,0x80,
0x03,0x80,
0x03,0x80,
0x1f,0xf0,
0x03,0x80,
0x03,0x80,
0x43,0x84,
0x63,0x8c,
0x77,0xdc,
0x3f,0xf8,
0x1c,0x70,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_3[] = {
0x00,0x00,
0x00,0x00,
0x00,0xc0,
0x01,0xc0,
0x01,0x80,
0x1d,0x70,
0x3f,0xf8,
0x7f,0xf0,
0x7f,0xe0,
0x7f,0xe0,
0x7f,0xe0,
0x7f,0xf0,
0x3f,0xf8,
0x1f,0xf0,
0x0e,0xe0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_4[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x5a,0xac,
0x5a,0xac,
0x5a,0xac,
0x5a,0xac,
0x5a,0xac,
0x5a,0xac,
0x02,0x08,
0x56,0xa8,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_5[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x3f,0xfc,
0x20,0x04,
0x6d,0xb4,
0x6d,0xb4,
0x6d,0xb4,
0x20,0x04,
0x3f,0xfc,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_6[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x3f,0xfc,
0x20,0x04,
0x61,0xb4,
0x61,0xb4,
0x61,0xb4,
0x20,0x04,
0x3f,0xfc,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_7[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x3f,0xfc,
0x20,0x04,
0x60,0x34,
0x60,0x34,
0x60,0x34,
0x20,0x04,
0x3f,0xfc,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_8[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x3f,0xfc,
0x20,0x04,
0x60,0x04,
0x60,0x04,
0x60,0x04,
0x20,0x04,
0x3f,0xfc,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_9[] = {
0x00,0x00,
0x00,0x00,
0x7f,0xfc,
0x40,0xe4,
0x70,0xe4,
0x40,0xe4,
0x70,0xe4,
0x40,0xe4,
0x70,0xa4,
0x40,0x04,
0x70,0x04,
0x40,0x04,
0x70,0x04,
0x40,0x04,
0x7f,0xfc,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_10[] = {
0x00,0x00,
0x00,0x00,
0x7f,0xfc,
0x7f,0xfc,
0x7f,0xfc,
0x40,0x04,
0x44,0xe4,
0x4d,0xb4,
0x5d,0xb4,
0x4d,0xb4,
0x4d,0xb4,
0x4d,0xb4,
0x5e,0xe4,
0x40,0x04,
0x7f,0xfc,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_11[] = {
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x07,0x80,
0x0f,0x80,
0x0f,0x80,
0x0d,0x80,
0x0c,0x00,
0x0c,0x00,
0x0c,0x10,
0x0d,0xa8,
0x0f,0xa8,
0x0f,0x90,
0x07,0xec,
0x03,0x80,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_12[] = {
0x00,0x00,
0x00,0x00,
0x3f,0xf8,
0x7f,0xcc,
0x7f,0xcc,
0x7d,0xcc,
0x7f,0xfc,
0x7c,0x7c,
0x49,0x24,
0x4a,0xa4,
0x49,0x24,
0x44,0x44,
0x53,0x84,
0x40,0x04,
0x3f,0xf8,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_13[] = {
0x00,0x00,
0x00,0x00,
0x30,0x06,
0x38,0x0e,
0x1c,0x1c,
0x0e,0x38,
0x07,0x70,
0x03,0xe0,
0x01,0xc0,
0x03,0xe0,
0x07,0x70,
0x0e,0x38,
0x1c,0x1c,
0x38,0x0e,
0x30,0x06,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_14[] = {
0x00,0x00,
0x00,0x00,
0x1f,0xf0,
0x3f,0xf8,
0x3f,0xf8,
0x77,0xdc,
0x63,0x8c,
0x63,0x8c,
0x7e,0xfc,
0x3c,0x78,
0x1c,0x70,
0x0f,0xe0,
0x0f,0xe0,
0x0a,0xa0,
0x0a,0xa0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_15[] = {
0x00,0x00,
0x00,0x00,
0x04,0x40,
0x04,0x40,
0x1f,0xf0,
0x10,0x10,
0x14,0x50,
0x70,0x1c,
0x47,0xc4,
0x40,0x04,
0x70,0x1c,
0x10,0x10,
0x17,0xd0,
0x24,0x48,
0x3c,0x78,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_16[] = {
0x00,0x00,
0x00,0x00,
0x01,0x00,
0x03,0x00,
0x1f,0xf0,
0x10,0x10,
0x14,0x50,
0x71,0x1c,
0x43,0x84,
0x41,0x04,
0x71,0x1c,
0x10,0x90,
0x17,0xd0,
0x24,0x48,
0x3c,0x78,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_17[] = {
0x00,0x00,
0x00,0x00,
0x20,0x08,
0x30,0x18,
0x1f,0xf0,
0x10,0x10,
0x14,0x50,
0x70,0x1c,
0x47,0xc4,
0x45,0x44,
0x72,0x9c,
0x10,0x10,
0x17,0xd0,
0x24,0x48,
0x3c,0x78,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_18[] = {
0x00,0x00,
0x00,0x00,
0x60,0x0c,
0x1f,0xf0,
0x10,0x10,
0x10,0x10,
0x14,0x50,
0x70,0x1c,
0x47,0xc4,
0x40,0x04,
0x70,0x1c,
0x10,0x10,
0x17,0xd0,
0x24,0x48,
0x3c,0x78,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_19[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x38,
0x00,0x38,
0x00,0x38,
0x38,0x38,
0x38,0x38,
0x3b,0xb8,
0x3b,0xb8,
0x3b,0xb8,
0x3b,0xb8,
0x7f,0xfc,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_20[] = {
0x00,0x00,
0x00,0x00,
0x3f,0xf8,
0x40,0x04,
0x40,0x04,
0x40,0x04,
0x40,0x04,
0x49,0x24,
0x40,0x04,
0x40,0x04,
0x40,0x04,
0x3f,0xc8,
0x00,0x28,
0x00,0x18,
0x00,0x08,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_21[] = {
0x00,0x00,
0x00,0x00,
0x0f,0xe0,
0x10,0x10,
0x30,0x08,
0x50,0x04,
0x4b,0xfc,
0x44,0x44,
0x44,0x44,
0x44,0x44,
0x43,0x84,
0x40,0x84,
0x21,0x08,
0x12,0x10,
0x0f,0xe0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_22[] = {
0x00,0x00,
0x00,0x00,
0x00,0xf0,
0x01,0x08,
0x02,0x08,
0x05,0x88,
0x0a,0x48,
0x14,0x48,
0x28,0x50,
0x10,0xa0,
0x21,0x40,
0x42,0x80,
0x45,0x00,
0x42,0x00,
0x3c,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_23[] = {
0x00,0x00,
0x00,0x00,
0x0f,0xe0,
0x10,0x10,
0x21,0x08,
0x41,0x04,
0x41,0x04,
0x41,0x04,
0x41,0x04,
0x41,0xe4,
0x40,0x04,
0x40,0x04,
0x20,0x08,
0x10,0x10,
0x0f,0xe0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_24[] = {
0x00,0x00,
0x00,0x00,
0x0f,0xf8,
0x08,0x08,
0x7f,0xc8,
0x40,0x68,
0x5b,0x48,
0x43,0x68,
0x5b,0x48,
0x40,0x68,
0x5f,0x48,
0x40,0x48,
0x5f,0x78,
0x40,0x40,
0x7f,0xc0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_25[] = {
0x00,0x00,
0x00,0x00,
0x0f,0xe0,
0x1f,0xf0,
0x38,0x78,
0x70,0x7c,
0x60,0xfc,
0x61,0xcc,
0x63,0x8c,
0x67,0x0c,
0x7e,0x0c,
0x7c,0x1c,
0x3c,0x38,
0x1f,0xf0,
0x0f,0xe0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_26[] = {
0x00,0x00,
0x00,0x00,
0x7f,0xc0,
0x40,0x60,
0x5f,0x50,
0x40,0x48,
0x5f,0x7c,
0x40,0x04,
0x5f,0xf4,
0x40,0x04,
0x5f,0xf4,
0x40,0x04,
0x5f,0xf4,
0x40,0x04,
0x7f,0xfc,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_27[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x03,0x80,
0x03,0x80,
0x03,0x80,
0x03,0x80,
0x1f,0xf0,
0x0f,0xe0,
0x07,0xc0,
0x03,0x80,
0x3f,0xf8,
0x3f,0xf8,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_28[] = {
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x0c,0x60,
0x1c,0x10,
0x38,0x78,
0x60,0xbc,
0x41,0x3c,
0x41,0xfc,
0x63,0xe4,
0x71,0xcc,
0x30,0xc8,
0x10,0x90,
0x0c,0x60,
0x03,0x80,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_29[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x3f,0xf8,
0x60,0x0c,
0x50,0x14,
0x48,0x24,
0x44,0x44,
0x46,0xc4,
0x49,0x24,
0x50,0x14,
0x60,0x0c,
0x3f,0xf8,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_30[] = {
0x00,0x00,
0x00,0x00,
0x01,0xf0,
0x02,0x08,
0x02,0xf8,
0x3f,0x88,
0x20,0x08,
0x20,0x08,
0x20,0x08,
0x20,0x08,
0x20,0x08,
0x3f,0xf8,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_31[] = {
0x00,0x00,
0x00,0x00,
0x01,0x00,
0x03,0xb0,
0x06,0xf0,
0x0c,0x70,
0x18,0x30,
0x30,0x18,
0x60,0x0c,
0x20,0x08,
0x26,0x68,
0x26,0x68,
0x26,0x08,
0x26,0x08,
0x3f,0xf8,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_32[] = {
0x00,0x00,
0x00,0x00,
0x60,0x0c,
0x50,0x14,
0x48,0x24,
0x47,0xc4,
0x40,0x04,
0x40,0x04,
0x48,0x24,
0x48,0x24,
0x00,0x00,
0x42,0x84,
0x01,0x00,
0x60,0x0c,
0x18,0x30,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_33[] = {
0x00,0x00,
0x00,0x00,
0x7f,0xfc,
0x40,0x04,
0x5b,0xf4,
0x58,0x04,
0x40,0x04,
0x5b,0xf4,
0x58,0x04,
0x40,0x04,
0x5b,0xf4,
0x58,0x04,
0x40,0x04,
0x7f,0xfc,
0x7f,0xfc,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_34[] = {
0x00,0x00,
0x00,0x00,
0x18,0xc0,
0x25,0x20,
0x25,0x20,
0x18,0xc0,
0x3f,0xcc,
0x20,0x54,
0x20,0x64,
0x20,0x64,
0x20,0x54,
0x3f,0xcc,
0x07,0x00,
0x0d,0x80,
0x18,0xc0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_35[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x07,0xf8,
0x07,0xf8,
0x07,0xf8,
0x07,0xf8,
0x04,0x08,
0x04,0x08,
0x04,0x08,
0x1c,0x38,
0x3c,0x78,
0x3c,0x78,
0x18,0x30,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_36[] = {
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x0c,0x60,
0x10,0x10,
0x13,0x90,
0x24,0x48,
0x24,0x48,
0x24,0x48,
0x13,0x90,
0x10,0x10,
0x08,0x20,
0x04,0x40,
0x02,0x80,
0x01,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_37[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x30,
0x00,0x78,
0x00,0xb8,
0x01,0x50,
0x02,0xe0,
0x05,0xc0,
0x0b,0x80,
0x17,0x00,
0x0e,0x00,
0x24,0x00,
0x30,0x00,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_38[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x07,0xc0,
0x07,0xc0,
0x07,0xc0,
0x03,0x80,
0x07,0xc0,
0x0f,0xe0,
0x1f,0xf0,
0x1f,0xf0,
0x1f,0xf0,
0x1f,0xf0,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_39[] = {
0x00,0x00,
0x00,0x00,
0x7f,0xfc,
0x40,0x04,
0x44,0x64,
0x4c,0x64,
0x4e,0x04,
0x5e,0x0c,
0x5f,0x1c,
0x77,0xbc,
0x77,0xbc,
0x6f,0xfc,
0x5e,0xf4,
0x7f,0xe4,
0x7f,0xfc,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_40[] = {
0x00,0x00,
0x00,0x00,
0x00,0x70,
0x00,0x98,
0x01,0x7c,
0x03,0xfc,
0x07,0xfc,
0x0b,0xf8,
0x11,0xf0,
0x20,0xe0,
0x40,0x40,
0x40,0x80,
0x41,0x00,
0x22,0x00,
0x1c,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_41[] = {
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x1b,0xb0,
0x3b,0xb8,
0x3b,0xb8,
0x7b,0xbc,
0x73,0x9c,
0x73,0x9c,
0x73,0x9c,
0x78,0x3c,
0x3c,0x78,
0x3f,0xf8,
0x1f,0xf0,
0x07,0xc0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_42[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x04,0x40,
0x04,0x40,
0x04,0x40,
0x0f,0xe0,
0x0f,0xe0,
0x07,0xc0,
0x07,0xc0,
0x03,0x80,
0x01,0x00,
0x01,0x00,
0x01,0x00,
0x01,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_43[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x04,0x48,
0x04,0x58,
0x04,0x30,
0x0f,0x60,
0x0e,0xc0,
0x05,0x80,
0x03,0x40,
0x06,0x80,
0x0d,0x00,
0x19,0x00,
0x31,0x00,
0x01,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_44[] = {
0x00,0x00,
0x00,0x00,
0x0f,0xe0,
0x0f,0xe8,
0x7f,0xfc,
0x40,0x04,
0x40,0x04,
0x5f,0xf4,
0x4f,0xe4,
0x4f,0xe4,
0x4f,0xe4,
0x7f,0xfc,
0x0f,0xe0,
0x0f,0xe0,
0x0f,0xe0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_45[] = {
0x00,0x00,
0x00,0x00,
0x01,0x00,
0x07,0xc0,
0x1f,0xf0,
0x3f,0xf8,
0x7f,0xfc,
0x49,0x24,
0x01,0x00,
0x01,0x00,
0x01,0x00,
0x01,0x00,
0x09,0x00,
0x09,0x00,
0x06,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_46[] = {
0x00,0x00,
0x00,0x00,
0x00,0x40,
0x00,0x60,
0x00,0x70,
0x7f,0xf8,
0x40,0x70,
0x40,0x60,
0x08,0x40,
0x18,0x10,
0x38,0x10,
0x7f,0xf0,
0x38,0x00,
0x18,0x00,
0x08,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_47[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x3e,0x00,
0x3f,0x80,
0x03,0xc0,
0x00,0xe0,
0x3c,0x70,
0x3e,0x30,
0x07,0x38,
0x03,0x98,
0x31,0x98,
0x79,0x98,
0x79,0x98,
0x30,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_48[] = {
0x00,0x00,
0x00,0x00,
0x71,0x70,
0x71,0x78,
0x70,0x7c,
0x7f,0xfc,
0x7f,0xfc,
0x60,0x0c,
0x67,0xec,
0x60,0x0c,
0x61,0xec,
0x60,0x0c,
0x60,0x6c,
0x60,0x0c,
0x7f,0xfc,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_49[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x04,0x40,
0x04,0x40,
0x04,0x40,
0x0f,0xe0,
0x08,0x20,
0x09,0x20,
0x09,0x20,
0x08,0x20,
0x0f,0xe0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_50[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x04,0x40,
0x04,0x40,
0x04,0x00,
0x04,0x00,
0x0f,0xe0,
0x08,0x20,
0x09,0x20,
0x09,0x20,
0x08,0x20,
0x0f,0xe0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_51[] = {
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x33,0x98,
0x3f,0xf8,
0x1f,0xf0,
0x1c,0x70,
0x78,0x3c,
0x78,0x3c,
0x78,0x3c,
0x1c,0x70,
0x1f,0xf0,
0x3f,0xf8,
0x33,0x98,
0x03,0x80,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_52[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x07,0xc0,
0x08,0x20,
0x10,0x10,
0x20,0x08,
0x28,0x28,
0x20,0x08,
0x24,0x48,
0x23,0x88,
0x10,0x10,
0x08,0x20,
0x07,0xc0,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_53[] = {
0x00,0x00,
0x00,0x00,
0x3f,0xf8,
0x7f,0xfc,
0x7f,0xc4,
0x7f,0x84,
0x7f,0x9c,
0x7f,0x9c,
0x7e,0x04,
0x7e,0x04,
0x7f,0x9c,
0x7f,0x9c,
0x7f,0x9c,
0x7f,0x9c,
0x3f,0x98,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_54[] = {
0x00,0x00,
0x00,0x00,
0x3f,0xf8,
0x7f,0xfc,
0x79,0xfc,
0x79,0xfc,
0x70,0x7c,
0x70,0x7c,
0x79,0xfc,
0x79,0xfc,
0x79,0xbc,
0x78,0x3c,
0x7c,0x7c,
0x7f,0xf8,
0x3f,0xf8,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_55[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x01,0xf0,
0x03,0x90,
0x07,0x90,
0x0f,0xf0,
0x1f,0xf0,
0x3f,0xe0,
0x7f,0xc0,
0x3f,0x80,
0x1f,0x00,
0x0e,0x00,
0x04,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_56[] = {
0x00,0x00,
0x00,0x00,
0x00,0x38,
0x00,0x18,
0x00,0x68,
0x08,0xc0,
0x1d,0x98,
0x37,0x18,
0x62,0x18,
0x40,0x18,
0x06,0x18,
0x36,0xd8,
0x36,0xd8,
0x36,0xd8,
0x36,0xd8,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_57[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x3f,0xf8,
0x3f,0xf8,
0x15,0x50,
0x15,0x50,
0x15,0x50,
0x15,0x50,
0x15,0x50,
0x15,0x50,
0x15,0x50,
0x15,0x50,
0x1f,0xf0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_58[] = {
0x00,0x00,
0x00,0x00,
0x3f,0xf8,
0x40,0x04,
0x43,0x84,
0x44,0x44,
0x40,0x44,
0x40,0x84,
0x41,0x04,
0x40,0x04,
0x41,0x04,
0x40,0x04,
0x3f,0xc4,
0x00,0x28,
0x00,0x10,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_59[] = {
0x00,0x00,
0x00,0x00,
0x3f,0xf8,
0x41,0x04,
0x41,0x04,
0x79,0x3c,
0x47,0x44,
0x44,0x44,
0x7c,0x7c,
0x44,0x44,
0x47,0xc4,
0x79,0x3c,
0x41,0x04,
0x41,0x04,
0x3f,0xf8,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_60[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x3f,0xf0,
0x3f,0xf0,
0x10,0x20,
0x17,0xa0,
0x0b,0x40,
0x04,0x80,
0x04,0x80,
0x0b,0x40,
0x17,0xa0,
0x10,0x20,
0x3f,0xf0,
0x3f,0xf0,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_61[] = {
0x00,0x00,
0x00,0x00,
0x03,0x80,
0x03,0x80,
0x03,0x80,
0x03,0x80,
0x03,0x80,
0x03,0x80,
0x03,0x80,
0x03,0x80,
0x03,0x80,
0x00,0x00,
0x03,0x80,
0x03,0x80,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_62[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x3e,0x00,
0x3f,0x80,
0x03,0xc0,
0x00,0xe0,
0x3c,0x70,
0x3e,0x30,
0x07,0x38,
0x03,0x98,
0x31,0x98,
0x39,0x98,
0x39,0x98,
0x00,0x00,
0x00,0x00
}; 
const unsigned char PROGMEM ICON_BITMAP_63[] = {
0x00,0x00,
0x00,0x00,
0x00,0x3c,
0x00,0xfc,
0x0e,0xfc,
0x3e,0xfc,
0x3e,0xfc,
0x3e,0xfc,
0x00,0x00,
0x3e,0xfc,
0x3e,0xfc,
0x3e,0xfc,
0x0e,0xfc,
0x00,0xfc,
0x00,0x3c,
0x00,0x00
};

const unsigned char PROGMEM ICON_BITMAP_64[] = {
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0xc0,
0x01,0x30,
0x06,0x08,
0x19,0x04,
0x20,0x82,
0x40,0x02,
0x40,0x02,
0x3f,0xfc,
0x00,0x00,
0x00,0x00,
0x00,0x00,
0x00,0x00
};

const unsigned char PROGMEM ICON_BITMAP_65[] = {
0x00,0x00,
0x00,0x00,
0x3f,0xe0,
0x10,0x40,
0x08,0x80,
0x05,0x00,
0x02,0x00,
0x02,0x00,
0x02,0x00,
0x00,0x0c,
0x00,0x6c,
0x03,0x6c,
0x1b,0x6c,
0x1b,0x6c,
0x00,0x00,
0x00,0x00
};

//----- Add new icon to below array
//----- You can access icon by index
PROGMEM const unsigned char* bitmap_array[] = {
ICON_BITMAP_1, ICON_BITMAP_2, ICON_BITMAP_3, ICON_BITMAP_4, ICON_BITMAP_5,     
ICON_BITMAP_6, ICON_BITMAP_7, ICON_BITMAP_8, ICON_BITMAP_9, ICON_BITMAP_10,  // ~10

ICON_BITMAP_11, ICON_BITMAP_12, ICON_BITMAP_13, ICON_BITMAP_14, ICON_BITMAP_15,     
ICON_BITMAP_16, ICON_BITMAP_17, ICON_BITMAP_18, ICON_BITMAP_19, ICON_BITMAP_20,  // ~20

ICON_BITMAP_21, ICON_BITMAP_22, ICON_BITMAP_23, ICON_BITMAP_24, ICON_BITMAP_25,     
ICON_BITMAP_26, ICON_BITMAP_27, ICON_BITMAP_28, ICON_BITMAP_29, ICON_BITMAP_30,  // ~30

ICON_BITMAP_31, ICON_BITMAP_32, ICON_BITMAP_33, ICON_BITMAP_34, ICON_BITMAP_35,     
ICON_BITMAP_36, ICON_BITMAP_37, ICON_BITMAP_38, ICON_BITMAP_39, ICON_BITMAP_40,  // ~40

ICON_BITMAP_41, ICON_BITMAP_42, ICON_BITMAP_43, ICON_BITMAP_44, ICON_BITMAP_45,     
ICON_BITMAP_46, ICON_BITMAP_47, ICON_BITMAP_48, ICON_BITMAP_49, ICON_BITMAP_50,  // ~50

ICON_BITMAP_51, ICON_BITMAP_52, ICON_BITMAP_53, ICON_BITMAP_54, ICON_BITMAP_55,     
ICON_BITMAP_56, ICON_BITMAP_57, ICON_BITMAP_58, ICON_BITMAP_59, ICON_BITMAP_60,  // ~60

ICON_BITMAP_61, ICON_BITMAP_62, ICON_BITMAP_63, ICON_BITMAP_64, ICON_BITMAP_65  // ~65
};

/*
 * Check icon name. It's arranged by the sequence of icon array.
 
ICON_BITMAP_android, ICON_BITMAP_ankor, ICON_BITMAP_apple, ICON_BITMAP_barcode, ICON_BITMAP_batt_1_full,     
ICON_BITMAP_batt_2_med, ICON_BITMAP_batt_3_low, ICON_BITMAP_batt_4_empty, ICON_BITMAP_bookmark, ICON_BITMAP_calendar,  // 0~9

ICON_BITMAP_call, ICON_BITMAP_camera, ICON_BITMAP_cancel, ICON_BITMAP_character_skull, ICON_BITMAP_character1,     
ICON_BITMAP_character2, ICON_BITMAP_character3, ICON_BITMAP_character4, ICON_BITMAP_chart, ICON_BITMAP_chat,  // 10~19

ICON_BITMAP_chrome, ICON_BITMAP_clip, ICON_BITMAP_clock, ICON_BITMAP_copy, ICON_BITMAP_denied,     
ICON_BITMAP_document, ICON_BITMAP_download, ICON_BITMAP_earth, ICON_BITMAP_email, ICON_BITMAP_folder,  // 20~29

ICON_BITMAP_home, ICON_BITMAP_kittcharacter_y, ICON_BITMAP_list, ICON_BITMAP_movie, ICON_BITMAP_music,     
ICON_BITMAP_navigator, ICON_BITMAP_pen, ICON_BITMAP_person, ICON_BITMAP_picture, ICON_BITMAP_pill,  // 30~39

ICON_BITMAP_power, ICON_BITMAP_power_plug, ICON_BITMAP_power_unplug, ICON_BITMAP_print, ICON_BITMAP_rain,     
ICON_BITMAP_refresh, ICON_BITMAP_rss, ICON_BITMAP_save, ICON_BITMAP_security_lock, ICON_BITMAP_security_unlock,  // 40~49

ICON_BITMAP_settings, ICON_BITMAP_smile, ICON_BITMAP_social_facebook, ICON_BITMAP_twitter, ICON_BITMAP_tag,     
ICON_BITMAP_trade, ICON_BITMAP_trash, ICON_BITMAP_unknown, ICON_BITMAP_usim, ICON_BITMAP_wait,  // 50~59

ICON_BITMAP_warning, ICON_BITMAP_wifi, ICON_BITMAP_windows, ICON_BITMAP_z_cloud, ICON_BITMAP_z_rfstatus,    // 60~64

*/


